/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.RejectWaitlistEntryRequest;
import com.clerk.backend_api.models.operations.RejectWaitlistEntryResponse;
import com.clerk.backend_api.operations.RejectWaitlistEntry;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class RejectWaitlistEntryRequestBuilder {
    private String waitlistEntryId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public RejectWaitlistEntryRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public RejectWaitlistEntryRequestBuilder waitlistEntryId(String waitlistEntryId) {
        Utils.checkNotNull(waitlistEntryId, "waitlistEntryId");
        this.waitlistEntryId = waitlistEntryId;
        return this;
    }

    public RejectWaitlistEntryRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public RejectWaitlistEntryRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private RejectWaitlistEntryRequest buildRequest() {
        RejectWaitlistEntryRequest request = new RejectWaitlistEntryRequest(this.waitlistEntryId);
        return request;
    }

    public RejectWaitlistEntryResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        RejectWaitlistEntry.Sync operation = new RejectWaitlistEntry.Sync(this.sdkConfiguration, options);
        RejectWaitlistEntryRequest request = this.buildRequest();
        return (RejectWaitlistEntryResponse)operation.handleResponse(operation.doRequest(request));
    }
}

