/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.RevokeActorTokenRequest;
import com.clerk.backend_api.models.operations.RevokeActorTokenResponse;
import com.clerk.backend_api.operations.RevokeActorToken;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class RevokeActorTokenRequestBuilder {
    private String actorTokenId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public RevokeActorTokenRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public RevokeActorTokenRequestBuilder actorTokenId(String actorTokenId) {
        Utils.checkNotNull(actorTokenId, "actorTokenId");
        this.actorTokenId = actorTokenId;
        return this;
    }

    public RevokeActorTokenRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public RevokeActorTokenRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private RevokeActorTokenRequest buildRequest() {
        RevokeActorTokenRequest request = new RevokeActorTokenRequest(this.actorTokenId);
        return request;
    }

    public RevokeActorTokenResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        RevokeActorToken.Sync operation = new RevokeActorToken.Sync(this.sdkConfiguration, options);
        RevokeActorTokenRequest request = this.buildRequest();
        return (RevokeActorTokenResponse)operation.handleResponse(operation.doRequest(request));
    }
}

