/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.RevokeInvitationRequest;
import com.clerk.backend_api.models.operations.RevokeInvitationResponse;
import com.clerk.backend_api.operations.RevokeInvitation;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class RevokeInvitationRequestBuilder {
    private String invitationId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public RevokeInvitationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public RevokeInvitationRequestBuilder invitationId(String invitationId) {
        Utils.checkNotNull(invitationId, "invitationId");
        this.invitationId = invitationId;
        return this;
    }

    public RevokeInvitationRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public RevokeInvitationRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private RevokeInvitationRequest buildRequest() {
        RevokeInvitationRequest request = new RevokeInvitationRequest(this.invitationId);
        return request;
    }

    public RevokeInvitationResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        RevokeInvitation.Sync operation = new RevokeInvitation.Sync(this.sdkConfiguration, options);
        RevokeInvitationRequest request = this.buildRequest();
        return (RevokeInvitationResponse)operation.handleResponse(operation.doRequest(request));
    }
}

