/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.InvitationRevoked;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class RevokeInvitationResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends InvitationRevoked> invitationRevoked;

    @JsonCreator
    public RevokeInvitationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends InvitationRevoked> invitationRevoked) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(invitationRevoked, "invitationRevoked");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.invitationRevoked = invitationRevoked;
    }

    public RevokeInvitationResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<InvitationRevoked> invitationRevoked() {
        return this.invitationRevoked;
    }

    public static Builder builder() {
        return new Builder();
    }

    public RevokeInvitationResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public RevokeInvitationResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public RevokeInvitationResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public RevokeInvitationResponse withInvitationRevoked(InvitationRevoked invitationRevoked) {
        Utils.checkNotNull(invitationRevoked, "invitationRevoked");
        this.invitationRevoked = Optional.ofNullable(invitationRevoked);
        return this;
    }

    public RevokeInvitationResponse withInvitationRevoked(Optional<? extends InvitationRevoked> invitationRevoked) {
        Utils.checkNotNull(invitationRevoked, "invitationRevoked");
        this.invitationRevoked = invitationRevoked;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevokeInvitationResponse other = (RevokeInvitationResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.invitationRevoked, other.invitationRevoked);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.invitationRevoked);
    }

    public String toString() {
        return Utils.toString(RevokeInvitationResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "invitationRevoked", this.invitationRevoked);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends InvitationRevoked> invitationRevoked = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder invitationRevoked(InvitationRevoked invitationRevoked) {
            Utils.checkNotNull(invitationRevoked, "invitationRevoked");
            this.invitationRevoked = Optional.ofNullable(invitationRevoked);
            return this;
        }

        public Builder invitationRevoked(Optional<? extends InvitationRevoked> invitationRevoked) {
            Utils.checkNotNull(invitationRevoked, "invitationRevoked");
            this.invitationRevoked = invitationRevoked;
            return this;
        }

        public RevokeInvitationResponse build() {
            return new RevokeInvitationResponse(this.contentType, this.statusCode, this.rawResponse, this.invitationRevoked);
        }
    }
}

