/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.RevokeM2MTokenRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class RevokeM2MTokenRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=m2m_token_id")
    private String m2mTokenId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private RevokeM2MTokenRequestBody requestBody;

    @JsonCreator
    public RevokeM2MTokenRequest(String m2mTokenId, RevokeM2MTokenRequestBody requestBody) {
        Utils.checkNotNull(m2mTokenId, "m2mTokenId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.m2mTokenId = m2mTokenId;
        this.requestBody = requestBody;
    }

    @JsonIgnore
    public String m2mTokenId() {
        return this.m2mTokenId;
    }

    @JsonIgnore
    public RevokeM2MTokenRequestBody requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public RevokeM2MTokenRequest withM2mTokenId(String m2mTokenId) {
        Utils.checkNotNull(m2mTokenId, "m2mTokenId");
        this.m2mTokenId = m2mTokenId;
        return this;
    }

    public RevokeM2MTokenRequest withRequestBody(RevokeM2MTokenRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevokeM2MTokenRequest other = (RevokeM2MTokenRequest)o;
        return Utils.enhancedDeepEquals(this.m2mTokenId, other.m2mTokenId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.m2mTokenId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(RevokeM2MTokenRequest.class, "m2mTokenId", this.m2mTokenId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String m2mTokenId;
        private RevokeM2MTokenRequestBody requestBody;

        private Builder() {
        }

        public Builder m2mTokenId(String m2mTokenId) {
            Utils.checkNotNull(m2mTokenId, "m2mTokenId");
            this.m2mTokenId = m2mTokenId;
            return this;
        }

        public Builder requestBody(RevokeM2MTokenRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public RevokeM2MTokenRequest build() {
            return new RevokeM2MTokenRequest(this.m2mTokenId, this.requestBody);
        }
    }
}

