/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.RevokeM2MTokenRequest;
import com.clerk.backend_api.models.operations.RevokeM2MTokenRequestBody;
import com.clerk.backend_api.models.operations.RevokeM2MTokenResponse;
import com.clerk.backend_api.operations.RevokeM2MToken;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class RevokeM2MTokenRequestBuilder {
    private String m2mTokenId;
    private RevokeM2MTokenRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public RevokeM2MTokenRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public RevokeM2MTokenRequestBuilder m2mTokenId(String m2mTokenId) {
        Utils.checkNotNull(m2mTokenId, "m2mTokenId");
        this.m2mTokenId = m2mTokenId;
        return this;
    }

    public RevokeM2MTokenRequestBuilder requestBody(RevokeM2MTokenRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public RevokeM2MTokenRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public RevokeM2MTokenRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private RevokeM2MTokenRequest buildRequest() {
        RevokeM2MTokenRequest request = new RevokeM2MTokenRequest(this.m2mTokenId, this.requestBody);
        return request;
    }

    public RevokeM2MTokenResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        RevokeM2MToken.Sync operation = new RevokeM2MToken.Sync(this.sdkConfiguration, options);
        RevokeM2MTokenRequest request = this.buildRequest();
        return (RevokeM2MTokenResponse)operation.handleResponse(operation.doRequest(request));
    }
}

