/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.RevokeOrganizationInvitationRequest;
import com.clerk.backend_api.models.operations.RevokeOrganizationInvitationRequestBody;
import com.clerk.backend_api.models.operations.RevokeOrganizationInvitationResponse;
import com.clerk.backend_api.operations.RevokeOrganizationInvitation;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class RevokeOrganizationInvitationRequestBuilder {
    private String organizationId;
    private String invitationId;
    private Optional<? extends RevokeOrganizationInvitationRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public RevokeOrganizationInvitationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public RevokeOrganizationInvitationRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public RevokeOrganizationInvitationRequestBuilder invitationId(String invitationId) {
        Utils.checkNotNull(invitationId, "invitationId");
        this.invitationId = invitationId;
        return this;
    }

    public RevokeOrganizationInvitationRequestBuilder requestBody(RevokeOrganizationInvitationRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public RevokeOrganizationInvitationRequestBuilder requestBody(Optional<? extends RevokeOrganizationInvitationRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public RevokeOrganizationInvitationRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public RevokeOrganizationInvitationRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private RevokeOrganizationInvitationRequest buildRequest() {
        RevokeOrganizationInvitationRequest request = new RevokeOrganizationInvitationRequest(this.organizationId, this.invitationId, this.requestBody);
        return request;
    }

    public RevokeOrganizationInvitationResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        RevokeOrganizationInvitation.Sync operation = new RevokeOrganizationInvitation.Sync(this.sdkConfiguration, options);
        RevokeOrganizationInvitationRequest request = this.buildRequest();
        return (RevokeOrganizationInvitationResponse)operation.handleResponse(operation.doRequest(request));
    }
}

