/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.SignInToken;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class RevokeSignInTokenResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends SignInToken> signInToken;

    @JsonCreator
    public RevokeSignInTokenResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends SignInToken> signInToken) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(signInToken, "signInToken");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.signInToken = signInToken;
    }

    public RevokeSignInTokenResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<SignInToken> signInToken() {
        return this.signInToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public RevokeSignInTokenResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public RevokeSignInTokenResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public RevokeSignInTokenResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public RevokeSignInTokenResponse withSignInToken(SignInToken signInToken) {
        Utils.checkNotNull(signInToken, "signInToken");
        this.signInToken = Optional.ofNullable(signInToken);
        return this;
    }

    public RevokeSignInTokenResponse withSignInToken(Optional<? extends SignInToken> signInToken) {
        Utils.checkNotNull(signInToken, "signInToken");
        this.signInToken = signInToken;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RevokeSignInTokenResponse other = (RevokeSignInTokenResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.signInToken, other.signInToken);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.signInToken);
    }

    public String toString() {
        return Utils.toString(RevokeSignInTokenResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "signInToken", this.signInToken);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends SignInToken> signInToken = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder signInToken(SignInToken signInToken) {
            Utils.checkNotNull(signInToken, "signInToken");
            this.signInToken = Optional.ofNullable(signInToken);
            return this;
        }

        public Builder signInToken(Optional<? extends SignInToken> signInToken) {
            Utils.checkNotNull(signInToken, "signInToken");
            this.signInToken = signInToken;
            return this;
        }

        public RevokeSignInTokenResponse build() {
            return new RevokeSignInTokenResponse(this.contentType, this.statusCode, this.rawResponse, this.signInToken);
        }
    }
}

