/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.SetUserProfileImageRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class SetUserProfileImageRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=user_id")
    private String userId;
    @SpeakeasyMetadata(value="request:mediaType=multipart/form-data")
    private SetUserProfileImageRequestBody requestBody;

    @JsonCreator
    public SetUserProfileImageRequest(String userId, SetUserProfileImageRequestBody requestBody) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.userId = userId;
        this.requestBody = requestBody;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public SetUserProfileImageRequestBody requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SetUserProfileImageRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public SetUserProfileImageRequest withRequestBody(SetUserProfileImageRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetUserProfileImageRequest other = (SetUserProfileImageRequest)o;
        return Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.userId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(SetUserProfileImageRequest.class, "userId", this.userId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String userId;
        private SetUserProfileImageRequestBody requestBody;

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder requestBody(SetUserProfileImageRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public SetUserProfileImageRequest build() {
            return new SetUserProfileImageRequest(this.userId, this.requestBody);
        }
    }
}

