/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.SetUserProfileImageRequest;
import com.clerk.backend_api.models.operations.SetUserProfileImageRequestBody;
import com.clerk.backend_api.models.operations.SetUserProfileImageResponse;
import com.clerk.backend_api.operations.SetUserProfileImage;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class SetUserProfileImageRequestBuilder {
    private String userId;
    private SetUserProfileImageRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public SetUserProfileImageRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public SetUserProfileImageRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public SetUserProfileImageRequestBuilder requestBody(SetUserProfileImageRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public SetUserProfileImageRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public SetUserProfileImageRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private SetUserProfileImageRequest buildRequest() {
        SetUserProfileImageRequest request = new SetUserProfileImageRequest(this.userId, this.requestBody);
        return request;
    }

    public SetUserProfileImageResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        SetUserProfileImage.Sync operation = new SetUserProfileImage.Sync(this.sdkConfiguration, options);
        SetUserProfileImageRequest request = this.buildRequest();
        return (SetUserProfileImageResponse)operation.handleResponse(operation.doRequest(request));
    }
}

