/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.ToggleTemplateDeliveryPathParamTemplateType;
import com.clerk.backend_api.models.operations.ToggleTemplateDeliveryRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class ToggleTemplateDeliveryRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=template_type")
    private ToggleTemplateDeliveryPathParamTemplateType templateType;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=slug")
    private String slug;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends ToggleTemplateDeliveryRequestBody> requestBody;

    @JsonCreator
    public ToggleTemplateDeliveryRequest(ToggleTemplateDeliveryPathParamTemplateType templateType, String slug, Optional<? extends ToggleTemplateDeliveryRequestBody> requestBody) {
        Utils.checkNotNull(templateType, "templateType");
        Utils.checkNotNull(slug, "slug");
        Utils.checkNotNull(requestBody, "requestBody");
        this.templateType = templateType;
        this.slug = slug;
        this.requestBody = requestBody;
    }

    public ToggleTemplateDeliveryRequest(ToggleTemplateDeliveryPathParamTemplateType templateType, String slug) {
        this(templateType, slug, Optional.empty());
    }

    @JsonIgnore
    public ToggleTemplateDeliveryPathParamTemplateType templateType() {
        return this.templateType;
    }

    @JsonIgnore
    public String slug() {
        return this.slug;
    }

    @JsonIgnore
    public Optional<ToggleTemplateDeliveryRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ToggleTemplateDeliveryRequest withTemplateType(ToggleTemplateDeliveryPathParamTemplateType templateType) {
        Utils.checkNotNull(templateType, "templateType");
        this.templateType = templateType;
        return this;
    }

    public ToggleTemplateDeliveryRequest withSlug(String slug) {
        Utils.checkNotNull(slug, "slug");
        this.slug = slug;
        return this;
    }

    public ToggleTemplateDeliveryRequest withRequestBody(ToggleTemplateDeliveryRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public ToggleTemplateDeliveryRequest withRequestBody(Optional<? extends ToggleTemplateDeliveryRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToggleTemplateDeliveryRequest other = (ToggleTemplateDeliveryRequest)o;
        return Utils.enhancedDeepEquals((Object)this.templateType, (Object)other.templateType) && Utils.enhancedDeepEquals(this.slug, other.slug) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.templateType, this.slug, this.requestBody});
    }

    public String toString() {
        return Utils.toString(ToggleTemplateDeliveryRequest.class, new Object[]{"templateType", this.templateType, "slug", this.slug, "requestBody", this.requestBody});
    }

    public static final class Builder {
        private ToggleTemplateDeliveryPathParamTemplateType templateType;
        private String slug;
        private Optional<? extends ToggleTemplateDeliveryRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder templateType(ToggleTemplateDeliveryPathParamTemplateType templateType) {
            Utils.checkNotNull(templateType, "templateType");
            this.templateType = templateType;
            return this;
        }

        public Builder slug(String slug) {
            Utils.checkNotNull(slug, "slug");
            this.slug = slug;
            return this;
        }

        public Builder requestBody(ToggleTemplateDeliveryRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends ToggleTemplateDeliveryRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public ToggleTemplateDeliveryRequest build() {
            return new ToggleTemplateDeliveryRequest(this.templateType, this.slug, this.requestBody);
        }
    }
}

