/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class ToggleTemplateDeliveryRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="delivered_by_clerk")
    private Optional<Boolean> deliveredByClerk;

    @JsonCreator
    public ToggleTemplateDeliveryRequestBody(@JsonProperty(value="delivered_by_clerk") Optional<Boolean> deliveredByClerk) {
        Utils.checkNotNull(deliveredByClerk, "deliveredByClerk");
        this.deliveredByClerk = deliveredByClerk;
    }

    public ToggleTemplateDeliveryRequestBody() {
        this(Optional.empty());
    }

    @JsonIgnore
    public Optional<Boolean> deliveredByClerk() {
        return this.deliveredByClerk;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ToggleTemplateDeliveryRequestBody withDeliveredByClerk(boolean deliveredByClerk) {
        Utils.checkNotNull(deliveredByClerk, "deliveredByClerk");
        this.deliveredByClerk = Optional.ofNullable(deliveredByClerk);
        return this;
    }

    public ToggleTemplateDeliveryRequestBody withDeliveredByClerk(Optional<Boolean> deliveredByClerk) {
        Utils.checkNotNull(deliveredByClerk, "deliveredByClerk");
        this.deliveredByClerk = deliveredByClerk;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToggleTemplateDeliveryRequestBody other = (ToggleTemplateDeliveryRequestBody)o;
        return Utils.enhancedDeepEquals(this.deliveredByClerk, other.deliveredByClerk);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.deliveredByClerk);
    }

    public String toString() {
        return Utils.toString(ToggleTemplateDeliveryRequestBody.class, "deliveredByClerk", this.deliveredByClerk);
    }

    public static final class Builder {
        private Optional<Boolean> deliveredByClerk = Optional.empty();

        private Builder() {
        }

        public Builder deliveredByClerk(boolean deliveredByClerk) {
            Utils.checkNotNull(deliveredByClerk, "deliveredByClerk");
            this.deliveredByClerk = Optional.ofNullable(deliveredByClerk);
            return this;
        }

        public Builder deliveredByClerk(Optional<Boolean> deliveredByClerk) {
            Utils.checkNotNull(deliveredByClerk, "deliveredByClerk");
            this.deliveredByClerk = deliveredByClerk;
            return this;
        }

        public ToggleTemplateDeliveryRequestBody build() {
            return new ToggleTemplateDeliveryRequestBody(this.deliveredByClerk);
        }
    }
}

