/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateAWSCredentialRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class UpdateAWSCredentialRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends UpdateAWSCredentialRequestBody> requestBody;

    @JsonCreator
    public UpdateAWSCredentialRequest(String id, Optional<? extends UpdateAWSCredentialRequestBody> requestBody) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(requestBody, "requestBody");
        this.id = id;
        this.requestBody = requestBody;
    }

    public UpdateAWSCredentialRequest(String id) {
        this(id, Optional.empty());
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<UpdateAWSCredentialRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateAWSCredentialRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public UpdateAWSCredentialRequest withRequestBody(UpdateAWSCredentialRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public UpdateAWSCredentialRequest withRequestBody(Optional<? extends UpdateAWSCredentialRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAWSCredentialRequest other = (UpdateAWSCredentialRequest)o;
        return Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.id, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateAWSCredentialRequest.class, "id", this.id, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String id;
        private Optional<? extends UpdateAWSCredentialRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder requestBody(UpdateAWSCredentialRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends UpdateAWSCredentialRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateAWSCredentialRequest build() {
            return new UpdateAWSCredentialRequest(this.id, this.requestBody);
        }
    }
}

