/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class UpdateAWSCredentialRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="access_key_id")
    private JsonNullable<String> accessKeyId;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="user_pool_ids")
    private Optional<? extends List<String>> userPoolIds;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="secret_access_key")
    private JsonNullable<String> secretAccessKey;

    @JsonCreator
    public UpdateAWSCredentialRequestBody(@JsonProperty(value="access_key_id") JsonNullable<String> accessKeyId, @JsonProperty(value="user_pool_ids") Optional<? extends List<String>> userPoolIds, @JsonProperty(value="secret_access_key") JsonNullable<String> secretAccessKey) {
        Utils.checkNotNull(accessKeyId, "accessKeyId");
        Utils.checkNotNull(userPoolIds, "userPoolIds");
        Utils.checkNotNull(secretAccessKey, "secretAccessKey");
        this.accessKeyId = accessKeyId;
        this.userPoolIds = userPoolIds;
        this.secretAccessKey = secretAccessKey;
    }

    public UpdateAWSCredentialRequestBody() {
        this((JsonNullable<String>)JsonNullable.undefined(), Optional.empty(), (JsonNullable<String>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<String> accessKeyId() {
        return this.accessKeyId;
    }

    @JsonIgnore
    public Optional<List<String>> userPoolIds() {
        return this.userPoolIds;
    }

    @JsonIgnore
    public JsonNullable<String> secretAccessKey() {
        return this.secretAccessKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateAWSCredentialRequestBody withAccessKeyId(String accessKeyId) {
        Utils.checkNotNull(accessKeyId, "accessKeyId");
        this.accessKeyId = JsonNullable.of((Object)accessKeyId);
        return this;
    }

    public UpdateAWSCredentialRequestBody withAccessKeyId(JsonNullable<String> accessKeyId) {
        Utils.checkNotNull(accessKeyId, "accessKeyId");
        this.accessKeyId = accessKeyId;
        return this;
    }

    public UpdateAWSCredentialRequestBody withUserPoolIds(List<String> userPoolIds) {
        Utils.checkNotNull(userPoolIds, "userPoolIds");
        this.userPoolIds = Optional.ofNullable(userPoolIds);
        return this;
    }

    public UpdateAWSCredentialRequestBody withUserPoolIds(Optional<? extends List<String>> userPoolIds) {
        Utils.checkNotNull(userPoolIds, "userPoolIds");
        this.userPoolIds = userPoolIds;
        return this;
    }

    public UpdateAWSCredentialRequestBody withSecretAccessKey(String secretAccessKey) {
        Utils.checkNotNull(secretAccessKey, "secretAccessKey");
        this.secretAccessKey = JsonNullable.of((Object)secretAccessKey);
        return this;
    }

    public UpdateAWSCredentialRequestBody withSecretAccessKey(JsonNullable<String> secretAccessKey) {
        Utils.checkNotNull(secretAccessKey, "secretAccessKey");
        this.secretAccessKey = secretAccessKey;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAWSCredentialRequestBody other = (UpdateAWSCredentialRequestBody)o;
        return Utils.enhancedDeepEquals(this.accessKeyId, other.accessKeyId) && Utils.enhancedDeepEquals(this.userPoolIds, other.userPoolIds) && Utils.enhancedDeepEquals(this.secretAccessKey, other.secretAccessKey);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.accessKeyId, this.userPoolIds, this.secretAccessKey);
    }

    public String toString() {
        return Utils.toString(UpdateAWSCredentialRequestBody.class, "accessKeyId", this.accessKeyId, "userPoolIds", this.userPoolIds, "secretAccessKey", this.secretAccessKey);
    }

    public static final class Builder {
        private JsonNullable<String> accessKeyId = JsonNullable.undefined();
        private Optional<? extends List<String>> userPoolIds = Optional.empty();
        private JsonNullable<String> secretAccessKey = JsonNullable.undefined();

        private Builder() {
        }

        public Builder accessKeyId(String accessKeyId) {
            Utils.checkNotNull(accessKeyId, "accessKeyId");
            this.accessKeyId = JsonNullable.of((Object)accessKeyId);
            return this;
        }

        public Builder accessKeyId(JsonNullable<String> accessKeyId) {
            Utils.checkNotNull(accessKeyId, "accessKeyId");
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder userPoolIds(List<String> userPoolIds) {
            Utils.checkNotNull(userPoolIds, "userPoolIds");
            this.userPoolIds = Optional.ofNullable(userPoolIds);
            return this;
        }

        public Builder userPoolIds(Optional<? extends List<String>> userPoolIds) {
            Utils.checkNotNull(userPoolIds, "userPoolIds");
            this.userPoolIds = userPoolIds;
            return this;
        }

        public Builder secretAccessKey(String secretAccessKey) {
            Utils.checkNotNull(secretAccessKey, "secretAccessKey");
            this.secretAccessKey = JsonNullable.of((Object)secretAccessKey);
            return this;
        }

        public Builder secretAccessKey(JsonNullable<String> secretAccessKey) {
            Utils.checkNotNull(secretAccessKey, "secretAccessKey");
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public UpdateAWSCredentialRequestBody build() {
            return new UpdateAWSCredentialRequestBody(this.accessKeyId, this.userPoolIds, this.secretAccessKey);
        }
    }
}

