/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UpdateAWSCredentialRequest;
import com.clerk.backend_api.models.operations.UpdateAWSCredentialRequestBody;
import com.clerk.backend_api.models.operations.UpdateAWSCredentialResponse;
import com.clerk.backend_api.operations.UpdateAWSCredential;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateAWSCredentialRequestBuilder {
    private String id;
    private Optional<? extends UpdateAWSCredentialRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UpdateAWSCredentialRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UpdateAWSCredentialRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public UpdateAWSCredentialRequestBuilder requestBody(UpdateAWSCredentialRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public UpdateAWSCredentialRequestBuilder requestBody(Optional<? extends UpdateAWSCredentialRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateAWSCredentialRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateAWSCredentialRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UpdateAWSCredentialRequest buildRequest() {
        UpdateAWSCredentialRequest request = new UpdateAWSCredentialRequest(this.id, this.requestBody);
        return request;
    }

    public UpdateAWSCredentialResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UpdateAWSCredential.Sync operation = new UpdateAWSCredential.Sync(this.sdkConfiguration, options);
        UpdateAWSCredentialRequest request = this.buildRequest();
        return (UpdateAWSCredentialResponse)operation.handleResponse(operation.doRequest(request));
    }
}

