/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.AWSCredential;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class UpdateAWSCredentialResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends AWSCredential> awsCredential;

    @JsonCreator
    public UpdateAWSCredentialResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends AWSCredential> awsCredential) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(awsCredential, "awsCredential");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.awsCredential = awsCredential;
    }

    public UpdateAWSCredentialResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<AWSCredential> awsCredential() {
        return this.awsCredential;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateAWSCredentialResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public UpdateAWSCredentialResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UpdateAWSCredentialResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public UpdateAWSCredentialResponse withAWSCredential(AWSCredential awsCredential) {
        Utils.checkNotNull(awsCredential, "awsCredential");
        this.awsCredential = Optional.ofNullable(awsCredential);
        return this;
    }

    public UpdateAWSCredentialResponse withAWSCredential(Optional<? extends AWSCredential> awsCredential) {
        Utils.checkNotNull(awsCredential, "awsCredential");
        this.awsCredential = awsCredential;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAWSCredentialResponse other = (UpdateAWSCredentialResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.awsCredential, other.awsCredential);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.awsCredential);
    }

    public String toString() {
        return Utils.toString(UpdateAWSCredentialResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "awsCredential", this.awsCredential);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends AWSCredential> awsCredential = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder awsCredential(AWSCredential awsCredential) {
            Utils.checkNotNull(awsCredential, "awsCredential");
            this.awsCredential = Optional.ofNullable(awsCredential);
            return this;
        }

        public Builder awsCredential(Optional<? extends AWSCredential> awsCredential) {
            Utils.checkNotNull(awsCredential, "awsCredential");
            this.awsCredential = awsCredential;
            return this;
        }

        public UpdateAWSCredentialResponse build() {
            return new UpdateAWSCredentialResponse(this.contentType, this.statusCode, this.rawResponse, this.awsCredential);
        }
    }
}

