/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UpdateEmailAddressRequest;
import com.clerk.backend_api.models.operations.UpdateEmailAddressRequestBody;
import com.clerk.backend_api.models.operations.UpdateEmailAddressResponse;
import com.clerk.backend_api.operations.UpdateEmailAddress;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateEmailAddressRequestBuilder {
    private String emailAddressId;
    private Optional<? extends UpdateEmailAddressRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UpdateEmailAddressRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UpdateEmailAddressRequestBuilder emailAddressId(String emailAddressId) {
        Utils.checkNotNull(emailAddressId, "emailAddressId");
        this.emailAddressId = emailAddressId;
        return this;
    }

    public UpdateEmailAddressRequestBuilder requestBody(UpdateEmailAddressRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public UpdateEmailAddressRequestBuilder requestBody(Optional<? extends UpdateEmailAddressRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateEmailAddressRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateEmailAddressRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UpdateEmailAddressRequest buildRequest() {
        UpdateEmailAddressRequest request = new UpdateEmailAddressRequest(this.emailAddressId, this.requestBody);
        return request;
    }

    public UpdateEmailAddressResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UpdateEmailAddress.Sync operation = new UpdateEmailAddress.Sync(this.sdkConfiguration, options);
        UpdateEmailAddressRequest request = this.buildRequest();
        return (UpdateEmailAddressResponse)operation.handleResponse(operation.doRequest(request));
    }
}

