/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.InstanceSettings;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class UpdateInstanceAuthConfigResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends InstanceSettings> instanceSettings;

    @JsonCreator
    public UpdateInstanceAuthConfigResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends InstanceSettings> instanceSettings) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(instanceSettings, "instanceSettings");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.instanceSettings = instanceSettings;
    }

    public UpdateInstanceAuthConfigResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<InstanceSettings> instanceSettings() {
        return this.instanceSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateInstanceAuthConfigResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public UpdateInstanceAuthConfigResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UpdateInstanceAuthConfigResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public UpdateInstanceAuthConfigResponse withInstanceSettings(InstanceSettings instanceSettings) {
        Utils.checkNotNull(instanceSettings, "instanceSettings");
        this.instanceSettings = Optional.ofNullable(instanceSettings);
        return this;
    }

    public UpdateInstanceAuthConfigResponse withInstanceSettings(Optional<? extends InstanceSettings> instanceSettings) {
        Utils.checkNotNull(instanceSettings, "instanceSettings");
        this.instanceSettings = instanceSettings;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateInstanceAuthConfigResponse other = (UpdateInstanceAuthConfigResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.instanceSettings, other.instanceSettings);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.instanceSettings);
    }

    public String toString() {
        return Utils.toString(UpdateInstanceAuthConfigResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "instanceSettings", this.instanceSettings);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends InstanceSettings> instanceSettings = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder instanceSettings(InstanceSettings instanceSettings) {
            Utils.checkNotNull(instanceSettings, "instanceSettings");
            this.instanceSettings = Optional.ofNullable(instanceSettings);
            return this;
        }

        public Builder instanceSettings(Optional<? extends InstanceSettings> instanceSettings) {
            Utils.checkNotNull(instanceSettings, "instanceSettings");
            this.instanceSettings = instanceSettings;
            return this;
        }

        public UpdateInstanceAuthConfigResponse build() {
            return new UpdateInstanceAuthConfigResponse(this.contentType, this.statusCode, this.rawResponse, this.instanceSettings);
        }
    }
}

