/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OrganizationSettings;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class UpdateInstanceOrganizationSettingsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OrganizationSettings> organizationSettings;

    @JsonCreator
    public UpdateInstanceOrganizationSettingsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OrganizationSettings> organizationSettings) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(organizationSettings, "organizationSettings");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.organizationSettings = organizationSettings;
    }

    public UpdateInstanceOrganizationSettingsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OrganizationSettings> organizationSettings() {
        return this.organizationSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateInstanceOrganizationSettingsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public UpdateInstanceOrganizationSettingsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UpdateInstanceOrganizationSettingsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public UpdateInstanceOrganizationSettingsResponse withOrganizationSettings(OrganizationSettings organizationSettings) {
        Utils.checkNotNull(organizationSettings, "organizationSettings");
        this.organizationSettings = Optional.ofNullable(organizationSettings);
        return this;
    }

    public UpdateInstanceOrganizationSettingsResponse withOrganizationSettings(Optional<? extends OrganizationSettings> organizationSettings) {
        Utils.checkNotNull(organizationSettings, "organizationSettings");
        this.organizationSettings = organizationSettings;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateInstanceOrganizationSettingsResponse other = (UpdateInstanceOrganizationSettingsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.organizationSettings, other.organizationSettings);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.organizationSettings);
    }

    public String toString() {
        return Utils.toString(UpdateInstanceOrganizationSettingsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "organizationSettings", this.organizationSettings);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OrganizationSettings> organizationSettings = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder organizationSettings(OrganizationSettings organizationSettings) {
            Utils.checkNotNull(organizationSettings, "organizationSettings");
            this.organizationSettings = Optional.ofNullable(organizationSettings);
            return this;
        }

        public Builder organizationSettings(Optional<? extends OrganizationSettings> organizationSettings) {
            Utils.checkNotNull(organizationSettings, "organizationSettings");
            this.organizationSettings = organizationSettings;
            return this;
        }

        public UpdateInstanceOrganizationSettingsResponse build() {
            return new UpdateInstanceOrganizationSettingsResponse(this.contentType, this.statusCode, this.rawResponse, this.organizationSettings);
        }
    }
}

