/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.InstanceRestrictions;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class UpdateInstanceRestrictionsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends InstanceRestrictions> instanceRestrictions;

    @JsonCreator
    public UpdateInstanceRestrictionsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends InstanceRestrictions> instanceRestrictions) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(instanceRestrictions, "instanceRestrictions");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.instanceRestrictions = instanceRestrictions;
    }

    public UpdateInstanceRestrictionsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<InstanceRestrictions> instanceRestrictions() {
        return this.instanceRestrictions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateInstanceRestrictionsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public UpdateInstanceRestrictionsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UpdateInstanceRestrictionsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public UpdateInstanceRestrictionsResponse withInstanceRestrictions(InstanceRestrictions instanceRestrictions) {
        Utils.checkNotNull(instanceRestrictions, "instanceRestrictions");
        this.instanceRestrictions = Optional.ofNullable(instanceRestrictions);
        return this;
    }

    public UpdateInstanceRestrictionsResponse withInstanceRestrictions(Optional<? extends InstanceRestrictions> instanceRestrictions) {
        Utils.checkNotNull(instanceRestrictions, "instanceRestrictions");
        this.instanceRestrictions = instanceRestrictions;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateInstanceRestrictionsResponse other = (UpdateInstanceRestrictionsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.instanceRestrictions, other.instanceRestrictions);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.instanceRestrictions);
    }

    public String toString() {
        return Utils.toString(UpdateInstanceRestrictionsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "instanceRestrictions", this.instanceRestrictions);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends InstanceRestrictions> instanceRestrictions = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder instanceRestrictions(InstanceRestrictions instanceRestrictions) {
            Utils.checkNotNull(instanceRestrictions, "instanceRestrictions");
            this.instanceRestrictions = Optional.ofNullable(instanceRestrictions);
            return this;
        }

        public Builder instanceRestrictions(Optional<? extends InstanceRestrictions> instanceRestrictions) {
            Utils.checkNotNull(instanceRestrictions, "instanceRestrictions");
            this.instanceRestrictions = instanceRestrictions;
            return this;
        }

        public UpdateInstanceRestrictionsResponse build() {
            return new UpdateInstanceRestrictionsResponse(this.contentType, this.statusCode, this.rawResponse, this.instanceRestrictions);
        }
    }
}

