/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateJWTTemplateRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class UpdateJWTTemplateRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=template_id")
    private String templateId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private Optional<? extends UpdateJWTTemplateRequestBody> requestBody;

    @JsonCreator
    public UpdateJWTTemplateRequest(String templateId, Optional<? extends UpdateJWTTemplateRequestBody> requestBody) {
        Utils.checkNotNull(templateId, "templateId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.templateId = templateId;
        this.requestBody = requestBody;
    }

    public UpdateJWTTemplateRequest(String templateId) {
        this(templateId, Optional.empty());
    }

    @JsonIgnore
    public String templateId() {
        return this.templateId;
    }

    @JsonIgnore
    public Optional<UpdateJWTTemplateRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateJWTTemplateRequest withTemplateId(String templateId) {
        Utils.checkNotNull(templateId, "templateId");
        this.templateId = templateId;
        return this;
    }

    public UpdateJWTTemplateRequest withRequestBody(UpdateJWTTemplateRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public UpdateJWTTemplateRequest withRequestBody(Optional<? extends UpdateJWTTemplateRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateJWTTemplateRequest other = (UpdateJWTTemplateRequest)o;
        return Utils.enhancedDeepEquals(this.templateId, other.templateId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.templateId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateJWTTemplateRequest.class, "templateId", this.templateId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String templateId;
        private Optional<? extends UpdateJWTTemplateRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder templateId(String templateId) {
            Utils.checkNotNull(templateId, "templateId");
            this.templateId = templateId;
            return this;
        }

        public Builder requestBody(UpdateJWTTemplateRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends UpdateJWTTemplateRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateJWTTemplateRequest build() {
            return new UpdateJWTTemplateRequest(this.templateId, this.requestBody);
        }
    }
}

