/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class UpdateMachineRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private Optional<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="default_token_ttl")
    private Optional<Long> defaultTokenTtl;

    @JsonCreator
    public UpdateMachineRequestBody(@JsonProperty(value="name") Optional<String> name, @JsonProperty(value="default_token_ttl") Optional<Long> defaultTokenTtl) {
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
        this.name = name;
        this.defaultTokenTtl = defaultTokenTtl;
    }

    public UpdateMachineRequestBody() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> name() {
        return this.name;
    }

    @JsonIgnore
    public Optional<Long> defaultTokenTtl() {
        return this.defaultTokenTtl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateMachineRequestBody withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }

    public UpdateMachineRequestBody withName(Optional<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public UpdateMachineRequestBody withDefaultTokenTtl(long defaultTokenTtl) {
        Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
        this.defaultTokenTtl = Optional.ofNullable(defaultTokenTtl);
        return this;
    }

    public UpdateMachineRequestBody withDefaultTokenTtl(Optional<Long> defaultTokenTtl) {
        Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
        this.defaultTokenTtl = defaultTokenTtl;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateMachineRequestBody other = (UpdateMachineRequestBody)o;
        return Utils.enhancedDeepEquals(this.name, other.name) && Utils.enhancedDeepEquals(this.defaultTokenTtl, other.defaultTokenTtl);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.name, this.defaultTokenTtl);
    }

    public String toString() {
        return Utils.toString(UpdateMachineRequestBody.class, "name", this.name, "defaultTokenTtl", this.defaultTokenTtl);
    }

    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<Long> defaultTokenTtl = Optional.empty();

        private Builder() {
        }

        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Optional<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder defaultTokenTtl(long defaultTokenTtl) {
            Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
            this.defaultTokenTtl = Optional.ofNullable(defaultTokenTtl);
            return this;
        }

        public Builder defaultTokenTtl(Optional<Long> defaultTokenTtl) {
            Utils.checkNotNull(defaultTokenTtl, "defaultTokenTtl");
            this.defaultTokenTtl = defaultTokenTtl;
            return this;
        }

        public UpdateMachineRequestBody build() {
            return new UpdateMachineRequestBody(this.name, this.defaultTokenTtl);
        }
    }
}

