/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UpdateMachineRequest;
import com.clerk.backend_api.models.operations.UpdateMachineRequestBody;
import com.clerk.backend_api.models.operations.UpdateMachineResponse;
import com.clerk.backend_api.operations.UpdateMachine;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateMachineRequestBuilder {
    private String machineId;
    private Optional<? extends UpdateMachineRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UpdateMachineRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UpdateMachineRequestBuilder machineId(String machineId) {
        Utils.checkNotNull(machineId, "machineId");
        this.machineId = machineId;
        return this;
    }

    public UpdateMachineRequestBuilder requestBody(UpdateMachineRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public UpdateMachineRequestBuilder requestBody(Optional<? extends UpdateMachineRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateMachineRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateMachineRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UpdateMachineRequest buildRequest() {
        UpdateMachineRequest request = new UpdateMachineRequest(this.machineId, this.requestBody);
        return request;
    }

    public UpdateMachineResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UpdateMachine.Sync operation = new UpdateMachine.Sync(this.sdkConfiguration, options);
        UpdateMachineRequest request = this.buildRequest();
        return (UpdateMachineResponse)operation.handleResponse(operation.doRequest(request));
    }
}

