/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateOAuthApplicationRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class UpdateOAuthApplicationRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=oauth_application_id")
    private String oauthApplicationId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private UpdateOAuthApplicationRequestBody requestBody;

    @JsonCreator
    public UpdateOAuthApplicationRequest(String oauthApplicationId, UpdateOAuthApplicationRequestBody requestBody) {
        Utils.checkNotNull(oauthApplicationId, "oauthApplicationId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.oauthApplicationId = oauthApplicationId;
        this.requestBody = requestBody;
    }

    @JsonIgnore
    public String oauthApplicationId() {
        return this.oauthApplicationId;
    }

    @JsonIgnore
    public UpdateOAuthApplicationRequestBody requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateOAuthApplicationRequest withOauthApplicationId(String oauthApplicationId) {
        Utils.checkNotNull(oauthApplicationId, "oauthApplicationId");
        this.oauthApplicationId = oauthApplicationId;
        return this;
    }

    public UpdateOAuthApplicationRequest withRequestBody(UpdateOAuthApplicationRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOAuthApplicationRequest other = (UpdateOAuthApplicationRequest)o;
        return Utils.enhancedDeepEquals(this.oauthApplicationId, other.oauthApplicationId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.oauthApplicationId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateOAuthApplicationRequest.class, "oauthApplicationId", this.oauthApplicationId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String oauthApplicationId;
        private UpdateOAuthApplicationRequestBody requestBody;

        private Builder() {
        }

        public Builder oauthApplicationId(String oauthApplicationId) {
            Utils.checkNotNull(oauthApplicationId, "oauthApplicationId");
            this.oauthApplicationId = oauthApplicationId;
            return this;
        }

        public Builder requestBody(UpdateOAuthApplicationRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateOAuthApplicationRequest build() {
            return new UpdateOAuthApplicationRequest(this.oauthApplicationId, this.requestBody);
        }
    }
}

