/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UpdateOAuthApplicationRequest;
import com.clerk.backend_api.models.operations.UpdateOAuthApplicationRequestBody;
import com.clerk.backend_api.models.operations.UpdateOAuthApplicationResponse;
import com.clerk.backend_api.operations.UpdateOAuthApplication;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateOAuthApplicationRequestBuilder {
    private String oauthApplicationId;
    private UpdateOAuthApplicationRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UpdateOAuthApplicationRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UpdateOAuthApplicationRequestBuilder oauthApplicationId(String oauthApplicationId) {
        Utils.checkNotNull(oauthApplicationId, "oauthApplicationId");
        this.oauthApplicationId = oauthApplicationId;
        return this;
    }

    public UpdateOAuthApplicationRequestBuilder requestBody(UpdateOAuthApplicationRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateOAuthApplicationRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateOAuthApplicationRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UpdateOAuthApplicationRequest buildRequest() {
        UpdateOAuthApplicationRequest request = new UpdateOAuthApplicationRequest(this.oauthApplicationId, this.requestBody);
        return request;
    }

    public UpdateOAuthApplicationResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UpdateOAuthApplication.Sync operation = new UpdateOAuthApplication.Sync(this.sdkConfiguration, options);
        UpdateOAuthApplicationRequest request = this.buildRequest();
        return (UpdateOAuthApplicationResponse)operation.handleResponse(operation.doRequest(request));
    }
}

