/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainRequest;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainRequestBody;
import com.clerk.backend_api.models.operations.UpdateOrganizationDomainResponse;
import com.clerk.backend_api.operations.UpdateOrganizationDomain;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateOrganizationDomainRequestBuilder {
    private String organizationId;
    private String domainId;
    private UpdateOrganizationDomainRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UpdateOrganizationDomainRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UpdateOrganizationDomainRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public UpdateOrganizationDomainRequestBuilder domainId(String domainId) {
        Utils.checkNotNull(domainId, "domainId");
        this.domainId = domainId;
        return this;
    }

    public UpdateOrganizationDomainRequestBuilder requestBody(UpdateOrganizationDomainRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateOrganizationDomainRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateOrganizationDomainRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UpdateOrganizationDomainRequest buildRequest() {
        UpdateOrganizationDomainRequest request = new UpdateOrganizationDomainRequest(this.organizationId, this.domainId, this.requestBody);
        return request;
    }

    public UpdateOrganizationDomainResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UpdateOrganizationDomain.Sync operation = new UpdateOrganizationDomain.Sync(this.sdkConfiguration, options);
        UpdateOrganizationDomainRequest request = this.buildRequest();
        return (UpdateOrganizationDomainResponse)operation.handleResponse(operation.doRequest(request));
    }
}

