/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OrganizationDomain;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class UpdateOrganizationDomainResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OrganizationDomain> organizationDomain;

    @JsonCreator
    public UpdateOrganizationDomainResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OrganizationDomain> organizationDomain) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(organizationDomain, "organizationDomain");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.organizationDomain = organizationDomain;
    }

    public UpdateOrganizationDomainResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OrganizationDomain> organizationDomain() {
        return this.organizationDomain;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateOrganizationDomainResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public UpdateOrganizationDomainResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UpdateOrganizationDomainResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public UpdateOrganizationDomainResponse withOrganizationDomain(OrganizationDomain organizationDomain) {
        Utils.checkNotNull(organizationDomain, "organizationDomain");
        this.organizationDomain = Optional.ofNullable(organizationDomain);
        return this;
    }

    public UpdateOrganizationDomainResponse withOrganizationDomain(Optional<? extends OrganizationDomain> organizationDomain) {
        Utils.checkNotNull(organizationDomain, "organizationDomain");
        this.organizationDomain = organizationDomain;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOrganizationDomainResponse other = (UpdateOrganizationDomainResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.organizationDomain, other.organizationDomain);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.organizationDomain);
    }

    public String toString() {
        return Utils.toString(UpdateOrganizationDomainResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "organizationDomain", this.organizationDomain);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OrganizationDomain> organizationDomain = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder organizationDomain(OrganizationDomain organizationDomain) {
            Utils.checkNotNull(organizationDomain, "organizationDomain");
            this.organizationDomain = Optional.ofNullable(organizationDomain);
            return this;
        }

        public Builder organizationDomain(Optional<? extends OrganizationDomain> organizationDomain) {
            Utils.checkNotNull(organizationDomain, "organizationDomain");
            this.organizationDomain = organizationDomain;
            return this;
        }

        public UpdateOrganizationDomainResponse build() {
            return new UpdateOrganizationDomainResponse(this.contentType, this.statusCode, this.rawResponse, this.organizationDomain);
        }
    }
}

