/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipRequest;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipRequestBody;
import com.clerk.backend_api.models.operations.UpdateOrganizationMembershipResponse;
import com.clerk.backend_api.operations.UpdateOrganizationMembership;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateOrganizationMembershipRequestBuilder {
    private String organizationId;
    private String userId;
    private UpdateOrganizationMembershipRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UpdateOrganizationMembershipRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UpdateOrganizationMembershipRequestBuilder organizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public UpdateOrganizationMembershipRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UpdateOrganizationMembershipRequestBuilder requestBody(UpdateOrganizationMembershipRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateOrganizationMembershipRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateOrganizationMembershipRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UpdateOrganizationMembershipRequest buildRequest() {
        UpdateOrganizationMembershipRequest request = new UpdateOrganizationMembershipRequest(this.organizationId, this.userId, this.requestBody);
        return request;
    }

    public UpdateOrganizationMembershipResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UpdateOrganizationMembership.Sync operation = new UpdateOrganizationMembership.Sync(this.sdkConfiguration, options);
        UpdateOrganizationMembershipRequest request = this.buildRequest();
        return (UpdateOrganizationMembershipResponse)operation.handleResponse(operation.doRequest(request));
    }
}

