/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateSAMLConnectionRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class UpdateSAMLConnectionRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=saml_connection_id")
    private String samlConnectionId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private UpdateSAMLConnectionRequestBody requestBody;

    @JsonCreator
    public UpdateSAMLConnectionRequest(String samlConnectionId, UpdateSAMLConnectionRequestBody requestBody) {
        Utils.checkNotNull(samlConnectionId, "samlConnectionId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.samlConnectionId = samlConnectionId;
        this.requestBody = requestBody;
    }

    @JsonIgnore
    public String samlConnectionId() {
        return this.samlConnectionId;
    }

    @JsonIgnore
    public UpdateSAMLConnectionRequestBody requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateSAMLConnectionRequest withSamlConnectionId(String samlConnectionId) {
        Utils.checkNotNull(samlConnectionId, "samlConnectionId");
        this.samlConnectionId = samlConnectionId;
        return this;
    }

    public UpdateSAMLConnectionRequest withRequestBody(UpdateSAMLConnectionRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSAMLConnectionRequest other = (UpdateSAMLConnectionRequest)o;
        return Utils.enhancedDeepEquals(this.samlConnectionId, other.samlConnectionId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.samlConnectionId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateSAMLConnectionRequest.class, "samlConnectionId", this.samlConnectionId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String samlConnectionId;
        private UpdateSAMLConnectionRequestBody requestBody;

        private Builder() {
        }

        public Builder samlConnectionId(String samlConnectionId) {
            Utils.checkNotNull(samlConnectionId, "samlConnectionId");
            this.samlConnectionId = samlConnectionId;
            return this;
        }

        public Builder requestBody(UpdateSAMLConnectionRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateSAMLConnectionRequest build() {
            return new UpdateSAMLConnectionRequest(this.samlConnectionId, this.requestBody);
        }
    }
}

