/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UpdateSAMLConnectionRequest;
import com.clerk.backend_api.models.operations.UpdateSAMLConnectionRequestBody;
import com.clerk.backend_api.models.operations.UpdateSAMLConnectionResponse;
import com.clerk.backend_api.operations.UpdateSAMLConnection;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateSAMLConnectionRequestBuilder {
    private String samlConnectionId;
    private UpdateSAMLConnectionRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UpdateSAMLConnectionRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UpdateSAMLConnectionRequestBuilder samlConnectionId(String samlConnectionId) {
        Utils.checkNotNull(samlConnectionId, "samlConnectionId");
        this.samlConnectionId = samlConnectionId;
        return this;
    }

    public UpdateSAMLConnectionRequestBuilder requestBody(UpdateSAMLConnectionRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateSAMLConnectionRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateSAMLConnectionRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UpdateSAMLConnectionRequest buildRequest() {
        UpdateSAMLConnectionRequest request = new UpdateSAMLConnectionRequest(this.samlConnectionId, this.requestBody);
        return request;
    }

    public UpdateSAMLConnectionResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UpdateSAMLConnection.Sync operation = new UpdateSAMLConnection.Sync(this.sdkConfiguration, options);
        UpdateSAMLConnectionRequest request = this.buildRequest();
        return (UpdateSAMLConnectionResponse)operation.handleResponse(operation.doRequest(request));
    }
}

