/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.SchemasSAMLConnection;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class UpdateSAMLConnectionResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends SchemasSAMLConnection> schemasSAMLConnection;

    @JsonCreator
    public UpdateSAMLConnectionResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends SchemasSAMLConnection> schemasSAMLConnection) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(schemasSAMLConnection, "schemasSAMLConnection");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.schemasSAMLConnection = schemasSAMLConnection;
    }

    public UpdateSAMLConnectionResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<SchemasSAMLConnection> schemasSAMLConnection() {
        return this.schemasSAMLConnection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateSAMLConnectionResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public UpdateSAMLConnectionResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UpdateSAMLConnectionResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public UpdateSAMLConnectionResponse withSchemasSAMLConnection(SchemasSAMLConnection schemasSAMLConnection) {
        Utils.checkNotNull(schemasSAMLConnection, "schemasSAMLConnection");
        this.schemasSAMLConnection = Optional.ofNullable(schemasSAMLConnection);
        return this;
    }

    public UpdateSAMLConnectionResponse withSchemasSAMLConnection(Optional<? extends SchemasSAMLConnection> schemasSAMLConnection) {
        Utils.checkNotNull(schemasSAMLConnection, "schemasSAMLConnection");
        this.schemasSAMLConnection = schemasSAMLConnection;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSAMLConnectionResponse other = (UpdateSAMLConnectionResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.schemasSAMLConnection, other.schemasSAMLConnection);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.schemasSAMLConnection);
    }

    public String toString() {
        return Utils.toString(UpdateSAMLConnectionResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "schemasSAMLConnection", this.schemasSAMLConnection);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends SchemasSAMLConnection> schemasSAMLConnection = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder schemasSAMLConnection(SchemasSAMLConnection schemasSAMLConnection) {
            Utils.checkNotNull(schemasSAMLConnection, "schemasSAMLConnection");
            this.schemasSAMLConnection = Optional.ofNullable(schemasSAMLConnection);
            return this;
        }

        public Builder schemasSAMLConnection(Optional<? extends SchemasSAMLConnection> schemasSAMLConnection) {
            Utils.checkNotNull(schemasSAMLConnection, "schemasSAMLConnection");
            this.schemasSAMLConnection = schemasSAMLConnection;
            return this;
        }

        public UpdateSAMLConnectionResponse build() {
            return new UpdateSAMLConnectionResponse(this.contentType, this.statusCode, this.rawResponse, this.schemasSAMLConnection);
        }
    }
}

