/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UpdateSignUpRequest;
import com.clerk.backend_api.models.operations.UpdateSignUpRequestBody;
import com.clerk.backend_api.models.operations.UpdateSignUpResponse;
import com.clerk.backend_api.operations.UpdateSignUp;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateSignUpRequestBuilder {
    private String id;
    private Optional<? extends UpdateSignUpRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UpdateSignUpRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UpdateSignUpRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public UpdateSignUpRequestBuilder requestBody(UpdateSignUpRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public UpdateSignUpRequestBuilder requestBody(Optional<? extends UpdateSignUpRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateSignUpRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateSignUpRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UpdateSignUpRequest buildRequest() {
        UpdateSignUpRequest request = new UpdateSignUpRequest(this.id, this.requestBody);
        return request;
    }

    public UpdateSignUpResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UpdateSignUp.Sync operation = new UpdateSignUp.Sync(this.sdkConfiguration, options);
        UpdateSignUpRequest request = this.buildRequest();
        return (UpdateSignUpResponse)operation.handleResponse(operation.doRequest(request));
    }
}

