/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.SignUp;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class UpdateSignUpResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends SignUp> signUp;

    @JsonCreator
    public UpdateSignUpResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends SignUp> signUp) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(signUp, "signUp");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.signUp = signUp;
    }

    public UpdateSignUpResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<SignUp> signUp() {
        return this.signUp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateSignUpResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public UpdateSignUpResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UpdateSignUpResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public UpdateSignUpResponse withSignUp(SignUp signUp) {
        Utils.checkNotNull(signUp, "signUp");
        this.signUp = Optional.ofNullable(signUp);
        return this;
    }

    public UpdateSignUpResponse withSignUp(Optional<? extends SignUp> signUp) {
        Utils.checkNotNull(signUp, "signUp");
        this.signUp = signUp;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSignUpResponse other = (UpdateSignUpResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.signUp, other.signUp);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.signUp);
    }

    public String toString() {
        return Utils.toString(UpdateSignUpResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "signUp", this.signUp);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends SignUp> signUp = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder signUp(SignUp signUp) {
            Utils.checkNotNull(signUp, "signUp");
            this.signUp = Optional.ofNullable(signUp);
            return this;
        }

        public Builder signUp(Optional<? extends SignUp> signUp) {
            Utils.checkNotNull(signUp, "signUp");
            this.signUp = signUp;
            return this;
        }

        public UpdateSignUpResponse build() {
            return new UpdateSignUpResponse(this.contentType, this.statusCode, this.rawResponse, this.signUp);
        }
    }
}

