/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UpdateUserRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class UpdateUserRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=user_id")
    private String userId;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private UpdateUserRequestBody requestBody;

    @JsonCreator
    public UpdateUserRequest(String userId, UpdateUserRequestBody requestBody) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.userId = userId;
        this.requestBody = requestBody;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public UpdateUserRequestBody requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UpdateUserRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UpdateUserRequest withRequestBody(UpdateUserRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest)o;
        return Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.userId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UpdateUserRequest.class, "userId", this.userId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String userId;
        private UpdateUserRequestBody requestBody;

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder requestBody(UpdateUserRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UpdateUserRequest build() {
            return new UpdateUserRequest(this.userId, this.requestBody);
        }
    }
}

