/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UpdateUserRequest;
import com.clerk.backend_api.models.operations.UpdateUserRequestBody;
import com.clerk.backend_api.models.operations.UpdateUserResponse;
import com.clerk.backend_api.operations.UpdateUser;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UpdateUserRequestBuilder {
    private String userId;
    private UpdateUserRequestBody requestBody;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UpdateUserRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UpdateUserRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UpdateUserRequestBuilder requestBody(UpdateUserRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public UpdateUserRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UpdateUserRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UpdateUserRequest buildRequest() {
        UpdateUserRequest request = new UpdateUserRequest(this.userId, this.requestBody);
        return request;
    }

    public UpdateUserResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UpdateUser.Sync operation = new UpdateUser.Sync(this.sdkConfiguration, options);
        UpdateUserRequest request = this.buildRequest();
        return (UpdateUserResponse)operation.handleResponse(operation.doRequest(request));
    }
}

