/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.UploadOrganizationLogoRequestBody;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;

public class UploadOrganizationLogoRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=organization_id")
    private String organizationId;
    @SpeakeasyMetadata(value="request:mediaType=multipart/form-data")
    private Optional<? extends UploadOrganizationLogoRequestBody> requestBody;

    @JsonCreator
    public UploadOrganizationLogoRequest(String organizationId, Optional<? extends UploadOrganizationLogoRequestBody> requestBody) {
        Utils.checkNotNull(organizationId, "organizationId");
        Utils.checkNotNull(requestBody, "requestBody");
        this.organizationId = organizationId;
        this.requestBody = requestBody;
    }

    public UploadOrganizationLogoRequest(String organizationId) {
        this(organizationId, Optional.empty());
    }

    @JsonIgnore
    public String organizationId() {
        return this.organizationId;
    }

    @JsonIgnore
    public Optional<UploadOrganizationLogoRequestBody> requestBody() {
        return this.requestBody;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UploadOrganizationLogoRequest withOrganizationId(String organizationId) {
        Utils.checkNotNull(organizationId, "organizationId");
        this.organizationId = organizationId;
        return this;
    }

    public UploadOrganizationLogoRequest withRequestBody(UploadOrganizationLogoRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.ofNullable(requestBody);
        return this;
    }

    public UploadOrganizationLogoRequest withRequestBody(Optional<? extends UploadOrganizationLogoRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadOrganizationLogoRequest other = (UploadOrganizationLogoRequest)o;
        return Utils.enhancedDeepEquals(this.organizationId, other.organizationId) && Utils.enhancedDeepEquals(this.requestBody, other.requestBody);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.organizationId, this.requestBody);
    }

    public String toString() {
        return Utils.toString(UploadOrganizationLogoRequest.class, "organizationId", this.organizationId, "requestBody", this.requestBody);
    }

    public static final class Builder {
        private String organizationId;
        private Optional<? extends UploadOrganizationLogoRequestBody> requestBody = Optional.empty();

        private Builder() {
        }

        public Builder organizationId(String organizationId) {
            Utils.checkNotNull(organizationId, "organizationId");
            this.organizationId = organizationId;
            return this;
        }

        public Builder requestBody(UploadOrganizationLogoRequestBody requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = Optional.ofNullable(requestBody);
            return this;
        }

        public Builder requestBody(Optional<? extends UploadOrganizationLogoRequestBody> requestBody) {
            Utils.checkNotNull(requestBody, "requestBody");
            this.requestBody = requestBody;
            return this;
        }

        public UploadOrganizationLogoRequest build() {
            return new UploadOrganizationLogoRequest(this.organizationId, this.requestBody);
        }
    }
}

