/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.components.OrganizationWithLogo;
import com.clerk.backend_api.utils.Response;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Optional;

public class UploadOrganizationLogoResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends OrganizationWithLogo> organizationWithLogo;

    @JsonCreator
    public UploadOrganizationLogoResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends OrganizationWithLogo> organizationWithLogo) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(organizationWithLogo, "organizationWithLogo");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.organizationWithLogo = organizationWithLogo;
    }

    public UploadOrganizationLogoResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<OrganizationWithLogo> organizationWithLogo() {
        return this.organizationWithLogo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UploadOrganizationLogoResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public UploadOrganizationLogoResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public UploadOrganizationLogoResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public UploadOrganizationLogoResponse withOrganizationWithLogo(OrganizationWithLogo organizationWithLogo) {
        Utils.checkNotNull(organizationWithLogo, "organizationWithLogo");
        this.organizationWithLogo = Optional.ofNullable(organizationWithLogo);
        return this;
    }

    public UploadOrganizationLogoResponse withOrganizationWithLogo(Optional<? extends OrganizationWithLogo> organizationWithLogo) {
        Utils.checkNotNull(organizationWithLogo, "organizationWithLogo");
        this.organizationWithLogo = organizationWithLogo;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadOrganizationLogoResponse other = (UploadOrganizationLogoResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.organizationWithLogo, other.organizationWithLogo);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.organizationWithLogo);
    }

    public String toString() {
        return Utils.toString(UploadOrganizationLogoResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "organizationWithLogo", this.organizationWithLogo);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends OrganizationWithLogo> organizationWithLogo = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder organizationWithLogo(OrganizationWithLogo organizationWithLogo) {
            Utils.checkNotNull(organizationWithLogo, "organizationWithLogo");
            this.organizationWithLogo = Optional.ofNullable(organizationWithLogo);
            return this;
        }

        public Builder organizationWithLogo(Optional<? extends OrganizationWithLogo> organizationWithLogo) {
            Utils.checkNotNull(organizationWithLogo, "organizationWithLogo");
            this.organizationWithLogo = organizationWithLogo;
            return this;
        }

        public UploadOrganizationLogoResponse build() {
            return new UploadOrganizationLogoResponse(this.contentType, this.statusCode, this.rawResponse, this.organizationWithLogo);
        }
    }
}

