/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class UserPasskeyDeleteRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=user_id")
    private String userId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=passkey_identification_id")
    private String passkeyIdentificationId;

    @JsonCreator
    public UserPasskeyDeleteRequest(String userId, String passkeyIdentificationId) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(passkeyIdentificationId, "passkeyIdentificationId");
        this.userId = userId;
        this.passkeyIdentificationId = passkeyIdentificationId;
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public String passkeyIdentificationId() {
        return this.passkeyIdentificationId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UserPasskeyDeleteRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UserPasskeyDeleteRequest withPasskeyIdentificationId(String passkeyIdentificationId) {
        Utils.checkNotNull(passkeyIdentificationId, "passkeyIdentificationId");
        this.passkeyIdentificationId = passkeyIdentificationId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserPasskeyDeleteRequest other = (UserPasskeyDeleteRequest)o;
        return Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.passkeyIdentificationId, other.passkeyIdentificationId);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.userId, this.passkeyIdentificationId);
    }

    public String toString() {
        return Utils.toString(UserPasskeyDeleteRequest.class, "userId", this.userId, "passkeyIdentificationId", this.passkeyIdentificationId);
    }

    public static final class Builder {
        private String userId;
        private String passkeyIdentificationId;

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder passkeyIdentificationId(String passkeyIdentificationId) {
            Utils.checkNotNull(passkeyIdentificationId, "passkeyIdentificationId");
            this.passkeyIdentificationId = passkeyIdentificationId;
            return this;
        }

        public UserPasskeyDeleteRequest build() {
            return new UserPasskeyDeleteRequest(this.userId, this.passkeyIdentificationId);
        }
    }
}

