/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UserPasskeyDeleteRequest;
import com.clerk.backend_api.models.operations.UserPasskeyDeleteResponse;
import com.clerk.backend_api.operations.UserPasskeyDelete;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UserPasskeyDeleteRequestBuilder {
    private String userId;
    private String passkeyIdentificationId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UserPasskeyDeleteRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UserPasskeyDeleteRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UserPasskeyDeleteRequestBuilder passkeyIdentificationId(String passkeyIdentificationId) {
        Utils.checkNotNull(passkeyIdentificationId, "passkeyIdentificationId");
        this.passkeyIdentificationId = passkeyIdentificationId;
        return this;
    }

    public UserPasskeyDeleteRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UserPasskeyDeleteRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UserPasskeyDeleteRequest buildRequest() {
        UserPasskeyDeleteRequest request = new UserPasskeyDeleteRequest(this.userId, this.passkeyIdentificationId);
        return request;
    }

    public UserPasskeyDeleteResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UserPasskeyDelete.Sync operation = new UserPasskeyDelete.Sync(this.sdkConfiguration, options);
        UserPasskeyDeleteRequest request = this.buildRequest();
        return (UserPasskeyDeleteResponse)operation.handleResponse(operation.doRequest(request));
    }
}

