/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.UserWeb3WalletDeleteRequest;
import com.clerk.backend_api.models.operations.UserWeb3WalletDeleteResponse;
import com.clerk.backend_api.operations.UserWeb3WalletDelete;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class UserWeb3WalletDeleteRequestBuilder {
    private String userId;
    private String web3WalletIdentificationId;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public UserWeb3WalletDeleteRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public UserWeb3WalletDeleteRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UserWeb3WalletDeleteRequestBuilder web3WalletIdentificationId(String web3WalletIdentificationId) {
        Utils.checkNotNull(web3WalletIdentificationId, "web3WalletIdentificationId");
        this.web3WalletIdentificationId = web3WalletIdentificationId;
        return this;
    }

    public UserWeb3WalletDeleteRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public UserWeb3WalletDeleteRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private UserWeb3WalletDeleteRequest buildRequest() {
        UserWeb3WalletDeleteRequest request = new UserWeb3WalletDeleteRequest(this.userId, this.web3WalletIdentificationId);
        return request;
    }

    public UserWeb3WalletDeleteResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        UserWeb3WalletDelete.Sync operation = new UserWeb3WalletDelete.Sync(this.sdkConfiguration, options);
        UserWeb3WalletDeleteRequest request = this.buildRequest();
        return (UserWeb3WalletDeleteResponse)operation.handleResponse(operation.doRequest(request));
    }
}

