/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.LazySingletonValue;
import com.clerk.backend_api.utils.SpeakeasyMetadata;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Optional;

public class UsersGetOrganizationMembershipsRequest {
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=user_id")
    private String userId;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=limit")
    private Optional<Long> limit;
    @SpeakeasyMetadata(value="queryParam:style=form,explode=true,name=offset")
    private Optional<Long> offset;

    @JsonCreator
    public UsersGetOrganizationMembershipsRequest(String userId, Optional<Long> limit, Optional<Long> offset) {
        Utils.checkNotNull(userId, "userId");
        Utils.checkNotNull(limit, "limit");
        Utils.checkNotNull(offset, "offset");
        this.userId = userId;
        this.limit = limit;
        this.offset = offset;
    }

    public UsersGetOrganizationMembershipsRequest(String userId) {
        this(userId, Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public String userId() {
        return this.userId;
    }

    @JsonIgnore
    public Optional<Long> limit() {
        return this.limit;
    }

    @JsonIgnore
    public Optional<Long> offset() {
        return this.offset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public UsersGetOrganizationMembershipsRequest withUserId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public UsersGetOrganizationMembershipsRequest withLimit(long limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = Optional.ofNullable(limit);
        return this;
    }

    public UsersGetOrganizationMembershipsRequest withLimit(Optional<Long> limit) {
        Utils.checkNotNull(limit, "limit");
        this.limit = limit;
        return this;
    }

    public UsersGetOrganizationMembershipsRequest withOffset(long offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = Optional.ofNullable(offset);
        return this;
    }

    public UsersGetOrganizationMembershipsRequest withOffset(Optional<Long> offset) {
        Utils.checkNotNull(offset, "offset");
        this.offset = offset;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsersGetOrganizationMembershipsRequest other = (UsersGetOrganizationMembershipsRequest)o;
        return Utils.enhancedDeepEquals(this.userId, other.userId) && Utils.enhancedDeepEquals(this.limit, other.limit) && Utils.enhancedDeepEquals(this.offset, other.offset);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.userId, this.limit, this.offset);
    }

    public String toString() {
        return Utils.toString(UsersGetOrganizationMembershipsRequest.class, "userId", this.userId, "limit", this.limit, "offset", this.offset);
    }

    public static final class Builder {
        private String userId;
        private Optional<Long> limit;
        private Optional<Long> offset;
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Limit = new LazySingletonValue<Optional<Long>>("limit", "10", new TypeReference<Optional<Long>>(){});
        private static final LazySingletonValue<Optional<Long>> _SINGLETON_VALUE_Offset = new LazySingletonValue<Optional<Long>>("offset", "0", new TypeReference<Optional<Long>>(){});

        private Builder() {
        }

        public Builder userId(String userId) {
            Utils.checkNotNull(userId, "userId");
            this.userId = userId;
            return this;
        }

        public Builder limit(long limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Optional<Long> limit) {
            Utils.checkNotNull(limit, "limit");
            this.limit = limit;
            return this;
        }

        public Builder offset(long offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public Builder offset(Optional<Long> offset) {
            Utils.checkNotNull(offset, "offset");
            this.offset = offset;
            return this;
        }

        public UsersGetOrganizationMembershipsRequest build() {
            if (this.limit == null) {
                this.limit = _SINGLETON_VALUE_Limit.value();
            }
            if (this.offset == null) {
                this.offset = _SINGLETON_VALUE_Offset.value();
            }
            return new UsersGetOrganizationMembershipsRequest(this.userId, this.limit, this.offset);
        }
    }
}

