/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.VerifyM2MTokenRequestBody;
import com.clerk.backend_api.models.operations.VerifyM2MTokenResponse;
import com.clerk.backend_api.operations.VerifyM2MToken;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class VerifyM2MTokenRequestBuilder {
    private VerifyM2MTokenRequestBody request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public VerifyM2MTokenRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public VerifyM2MTokenRequestBuilder request(VerifyM2MTokenRequestBody request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public VerifyM2MTokenRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public VerifyM2MTokenRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public VerifyM2MTokenResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        VerifyM2MToken.Sync operation = new VerifyM2MToken.Sync(this.sdkConfiguration, options);
        return (VerifyM2MTokenResponse)operation.handleResponse(operation.doRequest(this.request));
    }
}

