/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class VerifyOAuthAccessTokenRequestBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="access_token")
    private Optional<String> accessToken;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="secret")
    @Deprecated
    private Optional<String> secret;

    @JsonCreator
    public VerifyOAuthAccessTokenRequestBody(@JsonProperty(value="access_token") Optional<String> accessToken, @JsonProperty(value="secret") Optional<String> secret) {
        Utils.checkNotNull(accessToken, "accessToken");
        Utils.checkNotNull(secret, "secret");
        this.accessToken = accessToken;
        this.secret = secret;
    }

    public VerifyOAuthAccessTokenRequestBody() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<String> accessToken() {
        return this.accessToken;
    }

    @Deprecated
    @JsonIgnore
    public Optional<String> secret() {
        return this.secret;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VerifyOAuthAccessTokenRequestBody withAccessToken(String accessToken) {
        Utils.checkNotNull(accessToken, "accessToken");
        this.accessToken = Optional.ofNullable(accessToken);
        return this;
    }

    public VerifyOAuthAccessTokenRequestBody withAccessToken(Optional<String> accessToken) {
        Utils.checkNotNull(accessToken, "accessToken");
        this.accessToken = accessToken;
        return this;
    }

    @Deprecated
    public VerifyOAuthAccessTokenRequestBody withSecret(String secret) {
        Utils.checkNotNull(secret, "secret");
        this.secret = Optional.ofNullable(secret);
        return this;
    }

    @Deprecated
    public VerifyOAuthAccessTokenRequestBody withSecret(Optional<String> secret) {
        Utils.checkNotNull(secret, "secret");
        this.secret = secret;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyOAuthAccessTokenRequestBody other = (VerifyOAuthAccessTokenRequestBody)o;
        return Utils.enhancedDeepEquals(this.accessToken, other.accessToken) && Utils.enhancedDeepEquals(this.secret, other.secret);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.accessToken, this.secret);
    }

    public String toString() {
        return Utils.toString(VerifyOAuthAccessTokenRequestBody.class, "accessToken", this.accessToken, "secret", this.secret);
    }

    public static final class Builder {
        private Optional<String> accessToken = Optional.empty();
        @Deprecated
        private Optional<String> secret = Optional.empty();

        private Builder() {
        }

        public Builder accessToken(String accessToken) {
            Utils.checkNotNull(accessToken, "accessToken");
            this.accessToken = Optional.ofNullable(accessToken);
            return this;
        }

        public Builder accessToken(Optional<String> accessToken) {
            Utils.checkNotNull(accessToken, "accessToken");
            this.accessToken = accessToken;
            return this;
        }

        @Deprecated
        public Builder secret(String secret) {
            Utils.checkNotNull(secret, "secret");
            this.secret = Optional.ofNullable(secret);
            return this;
        }

        @Deprecated
        public Builder secret(Optional<String> secret) {
            Utils.checkNotNull(secret, "secret");
            this.secret = secret;
            return this;
        }

        public VerifyOAuthAccessTokenRequestBody build() {
            return new VerifyOAuthAccessTokenRequestBody(this.accessToken, this.secret);
        }
    }
}

