/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.VerifyOAuthAccessTokenRequestBody;
import com.clerk.backend_api.models.operations.VerifyOAuthAccessTokenResponse;
import com.clerk.backend_api.operations.VerifyOAuthAccessToken;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class VerifyOAuthAccessTokenRequestBuilder {
    private VerifyOAuthAccessTokenRequestBody request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public VerifyOAuthAccessTokenRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public VerifyOAuthAccessTokenRequestBuilder request(VerifyOAuthAccessTokenRequestBody request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public VerifyOAuthAccessTokenRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public VerifyOAuthAccessTokenRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public VerifyOAuthAccessTokenResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        VerifyOAuthAccessToken.Sync operation = new VerifyOAuthAccessToken.Sync(this.sdkConfiguration, options);
        return (VerifyOAuthAccessTokenResponse)operation.handleResponse(operation.doRequest(this.request));
    }
}

