/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.VerifyOAuthAccessTokenObject;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;

public class VerifyOAuthAccessTokenResponseBody {
    @JsonProperty(value="object")
    private VerifyOAuthAccessTokenObject object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="client_id")
    private String clientId;
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="scopes")
    private List<String> scopes;
    @JsonProperty(value="revoked")
    private boolean revoked;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="revocation_reason")
    private Optional<String> revocationReason;
    @JsonProperty(value="expired")
    private boolean expired;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonProperty(value="expiration")
    private Optional<Double> expiration;
    @JsonProperty(value="created_at")
    private double createdAt;
    @JsonProperty(value="updated_at")
    private double updatedAt;

    @JsonCreator
    public VerifyOAuthAccessTokenResponseBody(@JsonProperty(value="object") VerifyOAuthAccessTokenObject object, @JsonProperty(value="id") String id, @JsonProperty(value="client_id") String clientId, @JsonProperty(value="subject") String subject, @JsonProperty(value="scopes") List<String> scopes, @JsonProperty(value="revoked") boolean revoked, @JsonProperty(value="revocation_reason") Optional<String> revocationReason, @JsonProperty(value="expired") boolean expired, @JsonProperty(value="expiration") Optional<Double> expiration, @JsonProperty(value="created_at") double createdAt, @JsonProperty(value="updated_at") double updatedAt) {
        Utils.checkNotNull(object, "object");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(clientId, "clientId");
        Utils.checkNotNull(subject, "subject");
        Utils.checkNotNull(scopes, "scopes");
        Utils.checkNotNull(revoked, "revoked");
        Utils.checkNotNull(revocationReason, "revocationReason");
        Utils.checkNotNull(expired, "expired");
        Utils.checkNotNull(expiration, "expiration");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.object = object;
        this.id = id;
        this.clientId = clientId;
        this.subject = subject;
        this.scopes = scopes;
        this.revoked = revoked;
        this.revocationReason = revocationReason;
        this.expired = expired;
        this.expiration = expiration;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public VerifyOAuthAccessTokenResponseBody(VerifyOAuthAccessTokenObject object, String id, String clientId, String subject, List<String> scopes, boolean revoked, boolean expired, double createdAt, double updatedAt) {
        this(object, id, clientId, subject, scopes, revoked, Optional.empty(), expired, Optional.empty(), createdAt, updatedAt);
    }

    @JsonIgnore
    public VerifyOAuthAccessTokenObject object() {
        return this.object;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public String clientId() {
        return this.clientId;
    }

    @JsonIgnore
    public String subject() {
        return this.subject;
    }

    @JsonIgnore
    public List<String> scopes() {
        return this.scopes;
    }

    @JsonIgnore
    public boolean revoked() {
        return this.revoked;
    }

    @JsonIgnore
    public Optional<String> revocationReason() {
        return this.revocationReason;
    }

    @JsonIgnore
    public boolean expired() {
        return this.expired;
    }

    @JsonIgnore
    public Optional<Double> expiration() {
        return this.expiration;
    }

    @JsonIgnore
    public double createdAt() {
        return this.createdAt;
    }

    @JsonIgnore
    public double updatedAt() {
        return this.updatedAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VerifyOAuthAccessTokenResponseBody withObject(VerifyOAuthAccessTokenObject object) {
        Utils.checkNotNull(object, "object");
        this.object = object;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withClientId(String clientId) {
        Utils.checkNotNull(clientId, "clientId");
        this.clientId = clientId;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withSubject(String subject) {
        Utils.checkNotNull(subject, "subject");
        this.subject = subject;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withScopes(List<String> scopes) {
        Utils.checkNotNull(scopes, "scopes");
        this.scopes = scopes;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withRevoked(boolean revoked) {
        Utils.checkNotNull(revoked, "revoked");
        this.revoked = revoked;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withRevocationReason(String revocationReason) {
        Utils.checkNotNull(revocationReason, "revocationReason");
        this.revocationReason = Optional.ofNullable(revocationReason);
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withRevocationReason(Optional<String> revocationReason) {
        Utils.checkNotNull(revocationReason, "revocationReason");
        this.revocationReason = revocationReason;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withExpired(boolean expired) {
        Utils.checkNotNull(expired, "expired");
        this.expired = expired;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withExpiration(double expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = Optional.ofNullable(expiration);
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withExpiration(Optional<Double> expiration) {
        Utils.checkNotNull(expiration, "expiration");
        this.expiration = expiration;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withCreatedAt(double createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    public VerifyOAuthAccessTokenResponseBody withUpdatedAt(double updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyOAuthAccessTokenResponseBody other = (VerifyOAuthAccessTokenResponseBody)o;
        return Utils.enhancedDeepEquals((Object)this.object, (Object)other.object) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.clientId, other.clientId) && Utils.enhancedDeepEquals(this.subject, other.subject) && Utils.enhancedDeepEquals(this.scopes, other.scopes) && Utils.enhancedDeepEquals(this.revoked, other.revoked) && Utils.enhancedDeepEquals(this.revocationReason, other.revocationReason) && Utils.enhancedDeepEquals(this.expired, other.expired) && Utils.enhancedDeepEquals(this.expiration, other.expiration) && Utils.enhancedDeepEquals(this.createdAt, other.createdAt) && Utils.enhancedDeepEquals(this.updatedAt, other.updatedAt);
    }

    public int hashCode() {
        return Utils.enhancedHash(new Object[]{this.object, this.id, this.clientId, this.subject, this.scopes, this.revoked, this.revocationReason, this.expired, this.expiration, this.createdAt, this.updatedAt});
    }

    public String toString() {
        return Utils.toString(VerifyOAuthAccessTokenResponseBody.class, new Object[]{"object", this.object, "id", this.id, "clientId", this.clientId, "subject", this.subject, "scopes", this.scopes, "revoked", this.revoked, "revocationReason", this.revocationReason, "expired", this.expired, "expiration", this.expiration, "createdAt", this.createdAt, "updatedAt", this.updatedAt});
    }

    public static final class Builder {
        private VerifyOAuthAccessTokenObject object;
        private String id;
        private String clientId;
        private String subject;
        private List<String> scopes;
        private Boolean revoked;
        private Optional<String> revocationReason = Optional.empty();
        private Boolean expired;
        private Optional<Double> expiration = Optional.empty();
        private Double createdAt;
        private Double updatedAt;

        private Builder() {
        }

        public Builder object(VerifyOAuthAccessTokenObject object) {
            Utils.checkNotNull(object, "object");
            this.object = object;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder clientId(String clientId) {
            Utils.checkNotNull(clientId, "clientId");
            this.clientId = clientId;
            return this;
        }

        public Builder subject(String subject) {
            Utils.checkNotNull(subject, "subject");
            this.subject = subject;
            return this;
        }

        public Builder scopes(List<String> scopes) {
            Utils.checkNotNull(scopes, "scopes");
            this.scopes = scopes;
            return this;
        }

        public Builder revoked(boolean revoked) {
            Utils.checkNotNull(revoked, "revoked");
            this.revoked = revoked;
            return this;
        }

        public Builder revocationReason(String revocationReason) {
            Utils.checkNotNull(revocationReason, "revocationReason");
            this.revocationReason = Optional.ofNullable(revocationReason);
            return this;
        }

        public Builder revocationReason(Optional<String> revocationReason) {
            Utils.checkNotNull(revocationReason, "revocationReason");
            this.revocationReason = revocationReason;
            return this;
        }

        public Builder expired(boolean expired) {
            Utils.checkNotNull(expired, "expired");
            this.expired = expired;
            return this;
        }

        public Builder expiration(double expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = Optional.ofNullable(expiration);
            return this;
        }

        public Builder expiration(Optional<Double> expiration) {
            Utils.checkNotNull(expiration, "expiration");
            this.expiration = expiration;
            return this;
        }

        public Builder createdAt(double createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(double updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        public VerifyOAuthAccessTokenResponseBody build() {
            return new VerifyOAuthAccessTokenResponseBody(this.object, this.id, this.clientId, this.subject, this.scopes, this.revoked, this.revocationReason, this.expired, this.expiration, this.createdAt, this.updatedAt);
        }
    }
}

