/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.VerifyPasswordRequest;
import com.clerk.backend_api.models.operations.VerifyPasswordRequestBody;
import com.clerk.backend_api.models.operations.VerifyPasswordResponse;
import com.clerk.backend_api.operations.VerifyPassword;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class VerifyPasswordRequestBuilder {
    private String userId;
    private Optional<? extends VerifyPasswordRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public VerifyPasswordRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public VerifyPasswordRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public VerifyPasswordRequestBuilder requestBody(VerifyPasswordRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public VerifyPasswordRequestBuilder requestBody(Optional<? extends VerifyPasswordRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public VerifyPasswordRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public VerifyPasswordRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private VerifyPasswordRequest buildRequest() {
        VerifyPasswordRequest request = new VerifyPasswordRequest(this.userId, this.requestBody);
        return request;
    }

    public VerifyPasswordResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        VerifyPassword.Sync operation = new VerifyPassword.Sync(this.sdkConfiguration, options);
        VerifyPasswordRequest request = this.buildRequest();
        return (VerifyPasswordResponse)operation.handleResponse(operation.doRequest(request));
    }
}

