/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.models.operations.VerifyTOTPRequest;
import com.clerk.backend_api.models.operations.VerifyTOTPRequestBody;
import com.clerk.backend_api.models.operations.VerifyTOTPResponse;
import com.clerk.backend_api.operations.VerifyTOTP;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import java.util.Optional;

public class VerifyTOTPRequestBuilder {
    private String userId;
    private Optional<? extends VerifyTOTPRequestBody> requestBody = Optional.empty();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public VerifyTOTPRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public VerifyTOTPRequestBuilder userId(String userId) {
        Utils.checkNotNull(userId, "userId");
        this.userId = userId;
        return this;
    }

    public VerifyTOTPRequestBuilder requestBody(VerifyTOTPRequestBody requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = Optional.of(requestBody);
        return this;
    }

    public VerifyTOTPRequestBuilder requestBody(Optional<? extends VerifyTOTPRequestBody> requestBody) {
        Utils.checkNotNull(requestBody, "requestBody");
        this.requestBody = requestBody;
        return this;
    }

    public VerifyTOTPRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public VerifyTOTPRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private VerifyTOTPRequest buildRequest() {
        VerifyTOTPRequest request = new VerifyTOTPRequest(this.userId, this.requestBody);
        return request;
    }

    public VerifyTOTPResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        VerifyTOTP.Sync operation = new VerifyTOTP.Sync(this.sdkConfiguration, options);
        VerifyTOTPRequest request = this.buildRequest();
        return (VerifyTOTPResponse)operation.handleResponse(operation.doRequest(request));
    }
}

