/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.models.operations;

import com.clerk.backend_api.models.operations.CodeType;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;

public class VerifyTOTPResponseBody {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="verified")
    private Optional<Boolean> verified;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="code_type")
    private Optional<? extends CodeType> codeType;

    @JsonCreator
    public VerifyTOTPResponseBody(@JsonProperty(value="verified") Optional<Boolean> verified, @JsonProperty(value="code_type") Optional<? extends CodeType> codeType) {
        Utils.checkNotNull(verified, "verified");
        Utils.checkNotNull(codeType, "codeType");
        this.verified = verified;
        this.codeType = codeType;
    }

    public VerifyTOTPResponseBody() {
        this(Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Boolean> verified() {
        return this.verified;
    }

    @JsonIgnore
    public Optional<CodeType> codeType() {
        return this.codeType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public VerifyTOTPResponseBody withVerified(boolean verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = Optional.ofNullable(verified);
        return this;
    }

    public VerifyTOTPResponseBody withVerified(Optional<Boolean> verified) {
        Utils.checkNotNull(verified, "verified");
        this.verified = verified;
        return this;
    }

    public VerifyTOTPResponseBody withCodeType(CodeType codeType) {
        Utils.checkNotNull(codeType, "codeType");
        this.codeType = Optional.ofNullable(codeType);
        return this;
    }

    public VerifyTOTPResponseBody withCodeType(Optional<? extends CodeType> codeType) {
        Utils.checkNotNull(codeType, "codeType");
        this.codeType = codeType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifyTOTPResponseBody other = (VerifyTOTPResponseBody)o;
        return Utils.enhancedDeepEquals(this.verified, other.verified) && Utils.enhancedDeepEquals(this.codeType, other.codeType);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.verified, this.codeType);
    }

    public String toString() {
        return Utils.toString(VerifyTOTPResponseBody.class, "verified", this.verified, "codeType", this.codeType);
    }

    public static final class Builder {
        private Optional<Boolean> verified = Optional.empty();
        private Optional<? extends CodeType> codeType = Optional.empty();

        private Builder() {
        }

        public Builder verified(boolean verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = Optional.ofNullable(verified);
            return this;
        }

        public Builder verified(Optional<Boolean> verified) {
            Utils.checkNotNull(verified, "verified");
            this.verified = verified;
            return this;
        }

        public Builder codeType(CodeType codeType) {
            Utils.checkNotNull(codeType, "codeType");
            this.codeType = Optional.ofNullable(codeType);
            return this;
        }

        public Builder codeType(Optional<? extends CodeType> codeType) {
            Utils.checkNotNull(codeType, "codeType");
            this.codeType = codeType;
            return this;
        }

        public VerifyTOTPResponseBody build() {
            return new VerifyTOTPResponseBody(this.verified, this.codeType);
        }
    }
}

