/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.SecuritySource;
import com.clerk.backend_api.models.components.OAuthApplication;
import com.clerk.backend_api.models.errors.ClerkErrors;
import com.clerk.backend_api.models.errors.SDKError;
import com.clerk.backend_api.models.operations.GetOAuthApplicationRequest;
import com.clerk.backend_api.models.operations.GetOAuthApplicationResponse;
import com.clerk.backend_api.operations.Operations;
import com.clerk.backend_api.utils.BackoffStrategy;
import com.clerk.backend_api.utils.HTTPClient;
import com.clerk.backend_api.utils.HTTPRequest;
import com.clerk.backend_api.utils.Hook;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.Retries;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class GetOAuthApplication {

    public static class Sync
    extends Base
    implements Operations.RequestOperation<GetOAuthApplicationRequest, GetOAuthApplicationResponse> {
        public Sync(SDKConfiguration sdkConfiguration, Optional<Options> options) {
            super(sdkConfiguration, options);
        }

        private HttpRequest onBuildRequest(GetOAuthApplicationRequest request) throws Exception {
            HttpRequest req = this.buildRequest(request);
            return this.sdkConfiguration.hooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
            return this.sdkConfiguration.hooks().afterError(this.createAfterErrorContext(), Optional.ofNullable(response), Optional.ofNullable(error));
        }

        private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
            return this.sdkConfiguration.hooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public HttpResponse<InputStream> doRequest(GetOAuthApplicationRequest request) throws Exception {
            Retries retries = Retries.builder().action(() -> {
                HttpRequest r;
                try {
                    r = this.onBuildRequest(request);
                }
                catch (Exception e) {
                    throw new Retries.NonRetryableException(e);
                }
                try {
                    HttpResponse<InputStream> httpRes = this.client.send(r);
                    if (Utils.statusCodeMatches(httpRes.statusCode(), "403", "404", "4XX", "5XX")) {
                        return this.onError(httpRes, null);
                    }
                    return httpRes;
                }
                catch (Exception e) {
                    return this.onError(null, e);
                }
            }).retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).build();
            return this.onSuccess(retries.run());
        }

        @Override
        public GetOAuthApplicationResponse handleResponse(HttpResponse<InputStream> response) throws Exception {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            GetOAuthApplicationResponse.Builder resBuilder = GetOAuthApplicationResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            GetOAuthApplicationResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    OAuthApplication out = (OAuthApplication)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<OAuthApplication>(){});
                    res.withOAuthApplication(out);
                    return res;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "403", "404")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ClerkErrors out = (ClerkErrors)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ClerkErrors>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
            }
            throw new SDKError(response, response.statusCode(), "Unexpected status code received: " + response.statusCode(), Utils.extractByteArrayFromBody(response));
        }
    }

    static abstract class Base {
        final SDKConfiguration sdkConfiguration;
        final String baseUrl;
        final SecuritySource securitySource;
        final List<String> retryStatusCodes;
        final RetryConfig retryConfig;
        final HTTPClient client;

        public Base(SDKConfiguration sdkConfiguration, Optional<Options> options) {
            this.sdkConfiguration = sdkConfiguration;
            this.baseUrl = this.sdkConfiguration.serverUrl();
            this.securitySource = this.sdkConfiguration.securitySource();
            options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
            this.retryStatusCodes = List.of("5XX");
            this.retryConfig = options.flatMap(Options::retryConfig).or(sdkConfiguration::retryConfig).orElse(RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
            this.client = this.sdkConfiguration.client();
        }

        Optional<SecuritySource> securitySource() {
            return Optional.ofNullable(this.securitySource);
        }

        Hook.BeforeRequestContextImpl createBeforeRequestContext() {
            return new Hook.BeforeRequestContextImpl(this.sdkConfiguration, this.baseUrl, "GetOAuthApplication", Optional.of(List.of()), this.securitySource());
        }

        Hook.AfterSuccessContextImpl createAfterSuccessContext() {
            return new Hook.AfterSuccessContextImpl(this.sdkConfiguration, this.baseUrl, "GetOAuthApplication", Optional.of(List.of()), this.securitySource());
        }

        Hook.AfterErrorContextImpl createAfterErrorContext() {
            return new Hook.AfterErrorContextImpl(this.sdkConfiguration, this.baseUrl, "GetOAuthApplication", Optional.of(List.of()), this.securitySource());
        }

        HttpRequest buildRequest(GetOAuthApplicationRequest request) throws Exception {
            String url = Utils.generateURL(GetOAuthApplicationRequest.class, this.baseUrl, "/oauth_applications/{oauth_application_id}", request, null);
            HTTPRequest req = new HTTPRequest(url, "GET");
            req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
            Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());
            return req.build();
        }
    }
}

