/*
 * Decompiled with CFR 0.152.
 */
package com.clerk.backend_api.operations;

import com.clerk.backend_api.SDKConfiguration;
import com.clerk.backend_api.SecuritySource;
import com.clerk.backend_api.models.components.ProxyCheck;
import com.clerk.backend_api.models.errors.ClerkErrors;
import com.clerk.backend_api.models.errors.SDKError;
import com.clerk.backend_api.models.operations.VerifyDomainProxyRequestBody;
import com.clerk.backend_api.models.operations.VerifyDomainProxyResponse;
import com.clerk.backend_api.operations.Operations;
import com.clerk.backend_api.utils.BackoffStrategy;
import com.clerk.backend_api.utils.HTTPClient;
import com.clerk.backend_api.utils.HTTPRequest;
import com.clerk.backend_api.utils.Hook;
import com.clerk.backend_api.utils.Options;
import com.clerk.backend_api.utils.Retries;
import com.clerk.backend_api.utils.RetryConfig;
import com.clerk.backend_api.utils.SerializedBody;
import com.clerk.backend_api.utils.Utils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class VerifyDomainProxy {

    public static class Sync
    extends Base
    implements Operations.RequestOperation<Optional<? extends VerifyDomainProxyRequestBody>, VerifyDomainProxyResponse> {
        public Sync(SDKConfiguration sdkConfiguration, Optional<Options> options) {
            super(sdkConfiguration, options);
        }

        private HttpRequest onBuildRequest(Optional<? extends VerifyDomainProxyRequestBody> request) throws Exception {
            HttpRequest req = this.buildRequest(request);
            return this.sdkConfiguration.hooks().beforeRequest(this.createBeforeRequestContext(), req);
        }

        private HttpResponse<InputStream> onError(HttpResponse<InputStream> response, Exception error) throws Exception {
            return this.sdkConfiguration.hooks().afterError(this.createAfterErrorContext(), Optional.ofNullable(response), Optional.ofNullable(error));
        }

        private HttpResponse<InputStream> onSuccess(HttpResponse<InputStream> response) throws Exception {
            return this.sdkConfiguration.hooks().afterSuccess(this.createAfterSuccessContext(), response);
        }

        @Override
        public HttpResponse<InputStream> doRequest(Optional<? extends VerifyDomainProxyRequestBody> request) throws Exception {
            Retries retries = Retries.builder().action(() -> {
                HttpRequest r;
                try {
                    r = this.onBuildRequest(request);
                }
                catch (Exception e) {
                    throw new Retries.NonRetryableException(e);
                }
                try {
                    HttpResponse<InputStream> httpRes = this.client.send(r);
                    if (Utils.statusCodeMatches(httpRes.statusCode(), "400", "422", "4XX", "5XX")) {
                        return this.onError(httpRes, null);
                    }
                    return httpRes;
                }
                catch (Exception e) {
                    return this.onError(null, e);
                }
            }).retryConfig(this.retryConfig).statusCodes(this.retryStatusCodes).build();
            return this.onSuccess(retries.run());
        }

        @Override
        public VerifyDomainProxyResponse handleResponse(HttpResponse<InputStream> response) throws Exception {
            String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
            VerifyDomainProxyResponse.Builder resBuilder = VerifyDomainProxyResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
            VerifyDomainProxyResponse res = resBuilder.build();
            if (Utils.statusCodeMatches(response.statusCode(), "200")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ProxyCheck out = (ProxyCheck)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ProxyCheck>(){});
                    res.withProxyCheck(out);
                    return res;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "400", "422")) {
                if (Utils.contentTypeMatches(contentType, "application/json")) {
                    ClerkErrors out = (ClerkErrors)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ClerkErrors>(){});
                    throw out;
                }
                throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
                throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
            }
            if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
                throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
            }
            throw new SDKError(response, response.statusCode(), "Unexpected status code received: " + response.statusCode(), Utils.extractByteArrayFromBody(response));
        }
    }

    static abstract class Base {
        final SDKConfiguration sdkConfiguration;
        final String baseUrl;
        final SecuritySource securitySource;
        final List<String> retryStatusCodes;
        final RetryConfig retryConfig;
        final HTTPClient client;

        public Base(SDKConfiguration sdkConfiguration, Optional<Options> options) {
            this.sdkConfiguration = sdkConfiguration;
            this.baseUrl = this.sdkConfiguration.serverUrl();
            this.securitySource = this.sdkConfiguration.securitySource();
            options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
            this.retryStatusCodes = List.of("5XX");
            this.retryConfig = options.flatMap(Options::retryConfig).or(sdkConfiguration::retryConfig).orElse(RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
            this.client = this.sdkConfiguration.client();
        }

        Optional<SecuritySource> securitySource() {
            return Optional.ofNullable(this.securitySource);
        }

        Hook.BeforeRequestContextImpl createBeforeRequestContext() {
            return new Hook.BeforeRequestContextImpl(this.sdkConfiguration, this.baseUrl, "VerifyDomainProxy", Optional.of(List.of()), this.securitySource());
        }

        Hook.AfterSuccessContextImpl createAfterSuccessContext() {
            return new Hook.AfterSuccessContextImpl(this.sdkConfiguration, this.baseUrl, "VerifyDomainProxy", Optional.of(List.of()), this.securitySource());
        }

        Hook.AfterErrorContextImpl createAfterErrorContext() {
            return new Hook.AfterErrorContextImpl(this.sdkConfiguration, this.baseUrl, "VerifyDomainProxy", Optional.of(List.of()), this.securitySource());
        }

        HttpRequest buildRequest(Optional<? extends VerifyDomainProxyRequestBody> request) throws Exception {
            String url = Utils.generateURL(this.baseUrl, "/proxy_checks");
            HTTPRequest req = new HTTPRequest(url, "POST");
            Object convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Optional<? extends VerifyDomainProxyRequestBody>>(){});
            SerializedBody serializedRequestBody = Utils.serializeRequestBody(convertedRequest, "request", "json", false);
            req.setBody(Optional.ofNullable(serializedRequestBody));
            req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
            Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());
            return req.build();
        }
    }
}

